
//>>>>>>>>>>>>>>>>>>>>>>>>
//cgi-ltctwr.c
//>>>>>>>>>>
//This file contains the CGI responder functions for all the IC configuration pages.
//


#include <mqx.h>
#include <httpd.h>
#include <main.h>
#include <cgi.h>
#include <string.h>

#include <ltctwrutils.h>
#include <ltctwrboard.h>



_mqx_int cgi_ltc1859_data(HTTPSRV_CGI_REQ_STRUCT *param)
{
	uint_32 value, len;
        char buff[20];
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;
        HTTPSRV_CGI_RES_STRUCT response;
        
        
        response.ses_handle = param->ses_handle;
        response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
        response.status_code = 200;

	//Get pointer
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();
	value = (LTCTWR_Params_Ptr->result >> 16);
		
	len = snprintf(buff, 20, "%d\n", value);
        response.data = buff;
        response.data_length = len;
        response.content_length = response.data_length;
        HTTPSRV_cgi_write(&response);
        

	return response.content_length;
}



_mqx_int cgi_ltc1859_set(HTTPSRV_CGI_REQ_STRUCT *param) {
	uint_32  len = 0;
	char     channel[10], span[10], state[10];
        HTTPSRV_CGI_RES_STRUCT response;
	

	boolean  bParams = FALSE; 
	char buffer[100];

	
	uint_8 chanindex, spanindex, stateindex;
	uint_8 mask = 0x41;
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;
	

	//Get pointer and configure as the 1859
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();
        LTCTWR_Params_Ptr->chip = LTCTWR_1859;
	LTCTWR_Params_Ptr->mode = READ;



	//If we got a response of non-zero length
	
	if (param->content_length) {
    	len = param->content_length;
    	len = HTTPSRV_cgi_read(param->ses_handle, buffer, (len > sizeof(buffer)) ? sizeof(buffer) : len);
    	buffer[len] = 0;
    	param->content_length -= len;
        len = 0;
    	
    	//Check if all contents are present
		if (cgi_get_varval(buffer, "channel", channel, sizeof(channel)) &&
			cgi_get_varval(buffer, "span", span, sizeof(span)) &&
			cgi_get_varval(buffer, "state", state, sizeof(state))) {
			
			bParams =  TRUE;
         
            chanindex = (*(char*)channel) - mask; //Figure out the Channel
            printf("Channel Index: %d\n", chanindex);
            spanindex = (*(char*)span) - mask;//Figure out the Span
            printf("Span Index: %d\n", spanindex);
            stateindex = (*(char*)state) - mask;//Figure out the State
            printf("State Index: %d\n", stateindex);
            
            set_decoder_channel(LTC1859_channel, LTCTWR_Params_Ptr);
            
            LTCTWR_Params_Ptr->channel = chanindex;
            
            lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
		    LTCTWR_Params_Ptr->result = send_receive_LTC1859 (LTC1859ChannelSelect[chanindex], LTC1859SpanSelect[spanindex], LTC1859StateSelect[stateindex], LTCTWR_Params_Ptr->spifd);
		    //ioctl(LTCTWR_Params_Ptr->csfd, GPIO_IOCTL_WRITE_LOG1, NULL);
                     lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
		    //fflush (LTCTWR_Params_Ptr->spifd);
		    
		    //For Flushing
		    
		    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
		    LTCTWR_Params_Ptr->result = send_receive_LTC1859 (LTC1859ChannelSelect[chanindex], LTC1859SpanSelect[spanindex], LTC1859StateSelect[stateindex], LTCTWR_Params_Ptr->spifd);
		    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
            fflush (LTCTWR_Params_Ptr->spifd);
            
            printf("Read 1859 ADC Ch: %d -- Value: 0x%08x or %d \n\n", chanindex, LTCTWR_Params_Ptr->result, LTCTWR_Params_Ptr->result);
		response.ses_handle = param->ses_handle;
                 response.content_type = HTTPSRV_CONTENT_TYPE_HTML;
                 response.status_code = 200;	
    		response.data = 
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
			"<html><head><title>MQX</title>"
			"<meta http-equiv=\"REFRESH\" content=\"0;url=ltc1859.html\"></HEAD>"
			"<BODY></BODY></HTML>";   	
                response.data_length = strlen(response.data);
    response.content_length = 0;
    HTTPSRV_cgi_write(&response);
   		}
   	}
  
   
	if (!bParams) {
		response.data =  "No parameters received.<br>\n";
                response.data_length = strlen(response.data);
        HTTPSRV_cgi_write(&response);
	}
	
	
	response.data = "<br><br>\n</body></html>";
    response.data_length = strlen(response.data);
    HTTPSRV_cgi_write(&response);    
    return (response.content_length);
}



_mqx_int cgi_ltc2498_data(HTTPSRV_CGI_REQ_STRUCT *param)
{
	uint_32 value, len;
        char buff[20];
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;
        HTTPSRV_CGI_RES_STRUCT response;
        
        
        response.ses_handle = param->ses_handle;
        response.content_type = HTTPSRV_CONTENT_TYPE_PLAIN;
        response.status_code = 200;

	//Get pointer
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();
	
	value = (LTCTWR_Params_Ptr->result);  //For uint_32
		
	len = snprintf(buff, 20, "%d\n", value);
        response.data = buff;
        response.data_length = len;
        response.content_length = response.data_length;
        HTTPSRV_cgi_write(&response);
        

	return response.content_length;
}


_mqx_int cgi_ltc2498_set(HTTPSRV_CGI_REQ_STRUCT *param)
{
	uint_32  len = 0;
        char     channel[10], setting[10];
	boolean  bParams = FALSE; 
	char buffer[100];
        HTTPSRV_CGI_RES_STRUCT response;
	
	//char     Message[LOG_MESSAGE_SIZE];
      
	
	uint_8 chanindex, setindex;
	uint_8 mask = 0x41;
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;

	//Get pointer and configure as the 2498
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();
        LTCTWR_Params_Ptr->chip = LTCTWR_2498;
	LTCTWR_Params_Ptr->mode = READ;

	

	//If we got a response of non-zero length
	
	
	if (param->content_length) {
    	len = param->content_length;
    	len = HTTPSRV_cgi_read(param->ses_handle, buffer, (len > sizeof(buffer)) ? sizeof(buffer) : len);
    	buffer[len] = 0;
    	param->content_length -= len;
        len = 0;
    	
    	//Check if all contents are present
		if (cgi_get_varval(buffer, "channel", channel, sizeof(channel)) &&
			cgi_get_varval(buffer, "setting", setting, sizeof(setting))) {
			
			bParams =  TRUE;
         
            chanindex = (*(char*)channel) - mask; //Figure out the Channel
            printf("Channel Index: %d\n", chanindex);
            setindex = (*(char*)setting) - mask;//Figure out the Span
            printf("Setting Index: %d\n", setindex);
            
            set_decoder_channel(LTC2498_channel, LTCTWR_Params_Ptr);

            lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
            LTCTWR_Params_Ptr->result = send_receive_LTC2498 (LTC2498ChannelSelect[chanindex], LTC2498SettingSelect[setindex], LTCTWR_Params_Ptr->spifd);
	    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
//            printf("index: %d \n", LTCTWR_Params_Ptr->result);
	    //fflush (LTCTWR_Params_Ptr->spifd);
		    
	    //Gotta wait
	    _time_delay(300);
	    //For flushing
           
	    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
	    LTCTWR_Params_Ptr->result = send_receive_LTC2498 (LTC2498ChannelSelect[chanindex], LTC2498SettingSelect[setindex], LTCTWR_Params_Ptr->spifd);
	    lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
//            printf("index: %d \n", LTCTWR_Params_Ptr->result);
            fflush (LTCTWR_Params_Ptr->spifd);
            
            
            printf("Read 2498 ADC Ch: %d -- Value: 0x%08x or %d \n\n", chanindex, LTCTWR_Params_Ptr->result, LTCTWR_Params_Ptr->result);
////////////////SPECIAL REV D EDIT ////////////////////////////////
#if defined BSP_TWR_K60D100M
#if defined K60N512_REV_D
            set_decoder_channel(0x01, LTCTWR_Params_Ptr); // bring GPIO7 high to bring Ethernet transceiver out of reset
	    _time_delay(3500);			          // allow time for Ethernet transceiver to come out of reset
#endif            
#endif
////////////////END SPECIAL REV D EDIT ////////////////////////////////      
            
    		
            response.ses_handle = param->ses_handle;
                 response.content_type = HTTPSRV_CONTENT_TYPE_HTML;
                 response.status_code = 200;	
    		response.data = 
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
			"<html><head><title>MQX</title>"
			"<meta http-equiv=\"REFRESH\" content=\"0;url=ltc2498.html\"></HEAD>"
			"<BODY></BODY></HTML>";  		
                  response.data_length = strlen(response.data);
    response.content_length = 0;
    HTTPSRV_cgi_write(&response);
   		}
   	}
  
   
	if (!bParams) {
		response.data =  "No parameters received.<br>\n";
                response.data_length = strlen(response.data);
        HTTPSRV_cgi_write(&response);
	}
	
	
	response.data = "<br><br>\n</body></html>";
    response.data_length = strlen(response.data);
    HTTPSRV_cgi_write(&response);    
    return (response.content_length);
	
}


_mqx_int cgi_ltc2600_set(HTTPSRV_CGI_REQ_STRUCT *param)
{
	uint_32  len = 0;
	char     command[10], channel[10], value[40]; //, vref[10];
	uint_32  val,val_fract=0;
        HTTPSRV_CGI_RES_STRUCT response;
	
	uint_32  string_len=0;
	
	boolean  bParams = FALSE; 
	char buffer[100];
	
	uint_8 commindex, chanindex;
	uint_32 valueindex; 
        //reference = 0x0;
	uint_8 mask = 0x41;
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;

	//Get pointer and configure as the 2600
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();
    LTCTWR_Params_Ptr->chip = LTCTWR_2600;
	LTCTWR_Params_Ptr->mode = WRITE;

	

	//If we got a response of non-zero length
	
	if (param->content_length) {
    	len = param->content_length;
    	len = HTTPSRV_cgi_read(param->ses_handle, buffer, (len > sizeof(buffer)) ? sizeof(buffer) : len);
    	buffer[len] = 0;
    	param->content_length -= len;
        len = 0;
    	
    	//Check if all contents are present
		if (cgi_get_varval(buffer, "command", command, sizeof(command)) &&
			cgi_get_varval(buffer, "channel", channel, sizeof(channel)) &&
			cgi_get_varval(buffer, "value", value, sizeof(value))) {
			
			bParams =  TRUE;
         
            commindex = (*(char*)command) - mask; //Figure out the Command
            printf("Command Index: %d\n", commindex);
            chanindex = (*(char*)channel) - mask;//Figure out the Span
            printf("Channel Index: %d\n", chanindex);

            
  			//Figure out the value and the fractional value
            if (sscanf(value, "%d.%d", &val, &val_fract) >= 1) {
            
            	string_len = strlen(value);  //Find out how long the string is
            	printf("Length: %d\n", string_len);
            	
            	if((val<10) && (string_len <3))  //If it's just one digit
            	{
            		printf("Value0: %d (No Decimal)\n", val);
					valueindex = (uint_32)(val);
					valueindex = (valueindex << 16);	
            	}
				else if ((val<10) && (string_len == 3)) {
				    printf("Value1: %d.%d\n", val , val_fract);
					valueindex = (uint_32)(val * 10 + val_fract);
					valueindex = (valueindex << 16)/10;
          		}
          		else if ((val<10) && (string_len == 4))
          		{
          			printf("Value2: %d.%d\n", val , val_fract);
					valueindex = (uint_32)(val * 100 + val_fract);
					valueindex = (valueindex << 16)/100;       			
          		}
          		else if ((val<10) && (string_len == 5))
          		{
          			printf("Value3: %d.%d\n", val , val_fract);
					valueindex = (uint_32)(val * 1000 + val_fract);
					valueindex = (valueindex << 16)/1000;       			
          		}
          		else if ((val<10) && (string_len == 6))
          		{
          			printf("Value4: %d.%d\n", val , val_fract);
					valueindex = (uint_32)(val * 10000 + val_fract);
					valueindex = (valueindex << 16)/10000;       			
          		}

          		if(valueindex == 0x10000) valueindex--;
       		}
            
            
            set_decoder_channel(LTC2600_channel, LTCTWR_Params_Ptr);
            lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
            LTCTWR_Params_Ptr->result = send_receive_LTC2600 (LTC2600CommandSelect[commindex], LTC2600ChannelSelect[chanindex], valueindex, LTCTWR_Params_Ptr->spifd);
            lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
            fflush (LTCTWR_Params_Ptr->spifd);
            
            printf("Write 2600 DAC Ch: %d -- Value: 0x%08x or %d \n\n", chanindex, LTCTWR_Params_Ptr->result, LTCTWR_Params_Ptr->result);

        
    		response.ses_handle = param->ses_handle;
                 response.content_type = HTTPSRV_CONTENT_TYPE_HTML;
                 response.status_code = 200;	
    		response.data = 
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
			"<html><head><title>MQX</title>"
			"<meta http-equiv=\"REFRESH\" content=\"0;url=ltc2600.html\"></HEAD>"
			"<BODY></BODY></HTML>";   		
   		response.data_length = strlen(response.data);
    response.content_length = 0;
    HTTPSRV_cgi_write(&response);
   		}
   	}
  
   
	if (!bParams) {
		response.data =  "No parameters received.<br>\n";
                response.data_length = strlen(response.data);
        HTTPSRV_cgi_write(&response);
	}
	
	
	response.data = "<br><br>\n</body></html>";
    response.data_length = strlen(response.data);
    HTTPSRV_cgi_write(&response);    
    return (response.content_length);
}


_mqx_int cgi_ltc2704_set(HTTPSRV_CGI_REQ_STRUCT *param)
{
	uint_32  len = 0;
	char     command[10], channel[10], span[10], value[40]; //, vref[10];
	uint_32  val,val_fract=0;
	HTTPSRV_CGI_RES_STRUCT response;
	uint_32  string_len=0;
	
	boolean  bParams = FALSE; 
	char buffer[100];
	
	uint_8 commindex, chanindex, spanindex;
	uint_32 valueindex; 
        //reference = 0x0;
	uint_8 mask = 0x41;
	LTCTWR_PARAMS_PTR LTCTWR_Params_Ptr;

	//Get pointer and configure as the 2600
	LTCTWR_Params_Ptr = LTCTWR_GetParameters();
    LTCTWR_Params_Ptr->chip = LTCTWR_2704;
	LTCTWR_Params_Ptr->mode = WRITE;

	

	//If we got a response of non-zero length
	
	if (param->content_length) {
    	len = param->content_length;
    	len = HTTPSRV_cgi_read(param->ses_handle, buffer, (len > sizeof(buffer)) ? sizeof(buffer) : len);
    	buffer[len] = 0;
    	param->content_length -= len;
        len = 0;
    	
    	//Check if all contents are present
		if (cgi_get_varval(buffer, "command", command, sizeof(command)) &&
			cgi_get_varval(buffer, "channel", channel, sizeof(channel)) &&
			cgi_get_varval(buffer, "span", span, sizeof(span)) &&
			cgi_get_varval(buffer, "value", value, sizeof(value)) ) {
			
			bParams =  TRUE;
         
            commindex = (*(char*)command) - mask; //Figure out the Command
            printf("Command Index: %d\n", commindex);
            chanindex = (*(char*)channel) - mask;//Figure out the Channel
            printf("Channel Index: %d\n", chanindex);
            spanindex = (*(char*)span) - mask;//Figure out the Span
            printf("Span Index: %d\n", spanindex);
            
            
  			//Figure out the value and the fractional value
            if (sscanf(value, "%d.%d", &val, &val_fract) >= 1) {
            
            	string_len = strlen(value);  //Find out how long the string is
            	printf("Length: %d\n", string_len);
            	
            	if((val<10) && (string_len <3))  //If it's just one digit
            	{
            		printf("Value0: %d (No Decimal)\n", val);
					valueindex = (uint_32)(val);
					valueindex = (valueindex << 16);	
            	}
				else if ((val<10) && (string_len == 3)) {
				    printf("Value1: %d.%d\n", val , val_fract);
					valueindex = (uint_32)(val * 10 + val_fract);
					valueindex = (valueindex << 16)/10;
          		}
          		else if ((val<10) && (string_len == 4))
          		{
          			printf("Value2: %d.%d\n", val , val_fract);
					valueindex = (uint_32)(val * 100 + val_fract);
					valueindex = (valueindex << 16)/100;       			
          		}
          		else if ((val<10) && (string_len == 5))
          		{
          			printf("Value3: %d.%d\n", val , val_fract);
					valueindex = (uint_32)(val * 1000 + val_fract);
					valueindex = (valueindex << 16)/1000;       			
          		}
          		else if ((val<10) && (string_len == 6))
          		{
          			printf("Value4: %d.%d\n", val , val_fract);
					valueindex = (uint_32)(val * 10000 + val_fract);
					valueindex = (valueindex << 16)/10000;       			
          		}
          		//valueindex = valueindex/reference;
          		if(valueindex == 0x10000) valueindex--;
       		}
            
            set_decoder_channel(LTC2704_channel, LTCTWR_Params_Ptr);
////////////////SPECIAL REV D EDIT ////////////////////////////////
#if defined BSP_TWR_K60D100M  
#if defined K60N512_REV_D            
	    _time_delay(3500);	            
#endif
#endif
////////////////END SPECIAL REV D EDIT ////////////////////////////////              
            if(commindex < 3) 
            {
            	lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
            	LTCTWR_Params_Ptr->result = send_receive_LTC2704 (LTC2704CodeCommandSelect[commindex], LTC2704ChannelSelect[chanindex], valueindex, LTCTWR_Params_Ptr->spifd);
            	lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
            	
				//fflush (LTCTWR_Params_Ptr->spifd);
				lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
				LTCTWR_Params_Ptr->result = send_receive_LTC2704 (LTC2704SpanCommandSelect[commindex], LTC2704ChannelSelect[chanindex], LTC2704SpanSelect[spanindex], LTCTWR_Params_Ptr->spifd);
				lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
				fflush (LTCTWR_Params_Ptr->spifd);
            }
            else
            {	
            	lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_LOW);
            	LTCTWR_Params_Ptr->result = send_receive_LTC2704 (LTC2704CommandSelect[commindex-3], LTC2704ChannelSelect[chanindex], valueindex, LTCTWR_Params_Ptr->spifd);
            	lwgpio_set_value(&LTCTWR_Params_Ptr->cspin[0], LWGPIO_VALUE_HIGH);
            	fflush (LTCTWR_Params_Ptr->spifd);
            }

            printf("Write 2704 DAC Ch: %d -- Value: 0x%08x or %d \n\n", chanindex, LTCTWR_Params_Ptr->result, LTCTWR_Params_Ptr->result);
            
////////////////SPECIAL REV D EDIT ////////////////////////////////
#if defined BSP_TWR_K60D100M  
#if defined K60N512_REV_D
            set_decoder_channel(0x01, LTCTWR_Params_Ptr);            
	    _time_delay(3500);			
#endif
#endif
////////////////END SPECIAL REV D EDIT ////////////////////////////////                    

        
    		response.ses_handle = param->ses_handle;
                 response.content_type = HTTPSRV_CONTENT_TYPE_HTML;
                 response.status_code = 200;	
    		response.data =  
			"<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">"
			"<html><head><title>MQX</title>"
			"<meta http-equiv=\"REFRESH\" content=\"0;url=ltc2704.html\"></HEAD>";
	response.data_length = strlen(response.data);
    response.content_length = 0;
    HTTPSRV_cgi_write(&response);
   		}
   	}
  
   
	if (!bParams) {
		response.data =  "No parameters received.<br>\n";
                response.data_length = strlen(response.data);
        HTTPSRV_cgi_write(&response);
	}
	
	
	response.data = "<br><br>\n</body></html>";
    response.data_length = strlen(response.data);
    HTTPSRV_cgi_write(&response);    
    return (response.content_length);
}

